clear; clc

%add folder path and filename
myfolder='';
filename='all_tracks_filtered_cutoff_D_-Inf_Inf_µm^2ps_cutoff_MSD_0_2_cutoff_length_0_frames.csv'

%for scalebar
scale_pos_x = 0;
scale_pos_y = 0;
scale_pos_z = -50;
scale_len = 500/98.69;
scale_width = 15;

table = readtable([myfolder, '/', filename]);
Final_Mat_raw = table2array(table);
size_table = size(table);

Final_Mat = vertcat(Final_Mat_raw, nan(1,size_table(2)));
numT = size_table(2)/4;
''
for n=1:numT

    %plot(Final_Mat(:,3*n-2),Final_Mat(:,3*n-1),'color', all_colors(c(n),:));
    patch(Final_Mat(4:end,4*n-2),Final_Mat(4:end,4*n-3), Final_Mat(4:end,4*n-1), Final_Mat(4:end,4*n), 'EdgeColor', 'interp', 'FaceColor', 'none');
    fh=figure(1);
    ax1=fh.CurrentAxes;
    fh.WindowState = 'maximized';
    axis vis3d
    %xlim([0, 20])
    %ylim([0, 20])
    %zlim([0, 5])
    view(ax1,160,90)

end

CDataMapping = 'scaled';
axis off;
daspect([1 1 1]);

cb_patch=colorbar('Location','south', 'FontSize', 25);
set(gca,'YDir','reverse');
set(get(cb_patch,'title'),'string','time in s', 'FontSize', 25);
cb_patch.Position
cb_patch.Position(4) = 0.05 %width
cb_patch.Position(3) = 0.4 %length
%cb_patch.Position(2) = 0.3 %y
cb_patch.Position(1) = 0.3 %x



ax2 = axes('Position',[0.5 0.3 0.4 0.4]);
plot3(ax2,[scale_pos_x, scale_pos_x],[scale_pos_y, scale_pos_y + scale_len], [ scale_pos_z, scale_pos_z], 'LineWidth', scale_width, 'Color', 'black' )
ax2.Visible ='off';  
    view(ax2,90,0)

linkaxes([ax1,ax2])

saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_','.png']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_','.fig']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_','.pdf']))